;**********************************************
; test internal ADC   of PIC18F458
; Hardware  : CP-PIC V3.0&V4.0
; OSC   10MHz
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 30/7/2002
;**********************************************

     list p=18f458                 ; list directive to define processor
     #include <p18f458.inc>        ; processor specific variable definitions
    dt1       EQU       0x20
    dt2       EQU       0x21
    dt3       EQU       0x22
    B1        EQU       0x31
    BB        EQU       0x32
;***********************************
          ORG  0x0000          

          clrf      ADCON1 
          bsf       ADCON1,7       ; ADFM = 1, AN0-AN7 is analog input
          clrf      TRISC          ; port d is output
	  clrf	    TRISB
          movlw     0x40           ; BAUD rate 9600
          movwf     SPBRG
          clrf      TXSTA          ; 8 bits data ,no,1 stop
          bsf       RCSTA,SPEN     ; Asynchronous serial port enable
          bsf       RCSTA,CREN     ; continuous receive
          bsf       TXSTA,TXEN     ; Transmit enable
          BSF	    TXSTA,BRGH	   ; HI SPEED
          movlw     10000001
          movwf     ADCON0         ; Clock=Fosc/32, ADC operate, Channel 0

;************ start conversion  **************

bbb       bsf       ADCON0,2       ; start conversion
Loop      btfsc     ADCON0,2       
          goto      Loop           ; DONE = 1
                                   ; DONE = 0
	
NEW       movlw     0x0C           ; Clear display
          call      SEND
          movlw     "D"
          call      SEND
          movlw     "A"
          call      SEND
          movlw     "T"
          call      SEND
          movlw     "A"
          call      SEND
          movlw     " "
          call      SEND
          movlw     "I"
          call      SEND        
	  movlw     "N"
          call      SEND
          movlw     " "
          call      SEND
                          
          movlw     0xA             ; new line
          call      SEND
          movlw     0xD
          call      SEND
	  movlw     "="
          call      SEND
 	  movlw     " "
	  call      SEND

	  movf	    ADRESH,w
	  call      ADJT
	  movf      ADRESL,w       ; read lower 8 bit
	  call      ADJT
	  call      delay
	  goto      bbb

  
	

;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      movwf     BB             ; B1 = HHHH LLLL
          swapf     BB,W           ; W  = LLLL HHHH
	  call      CHECK          ; Check data and convert to Ascii Hi Byte
          movf      BB,W
          call      CHECK	   ; Check data and convert to Ascii Lo Byte
          return

CHECK     andlw     0X0F
	  movwf     B1
	  sublw     0X0A
	  bz        CC            ; = 0XA JUMP TO CC 
	  bc        CONV          ; < 0XA JUMP TO CONV
CC	  movf      B1,W          ; A -> F
	  addlw     0X37
	  call      SEND           ; SEND FIRST DIGIT
	  return
CONV      movf      B1,W          ; 0 -> 9
          addlw     0X30
	  call      SEND	   ; SEND LAST DIGIT
          return

;********* SEND DATA TO RS-232 PORT ******************

SEND	  movwf     TXREG          ; Send recent data to TX 
wait1     lfsr      0,TXSTA        ; 
          btfss     INDF0,1        ; check TRMT bit in TXSTA (FSR)
          goto      wait1   
	  return

;********* DELAY LOOP ************
	
delay     movlw	    5
	  movwf	    dt1
sd3	  clrf      dt2
sd2       clrf      dt3
sd1       decfsz    dt3
          goto      sd1
          decfsz    dt2
          goto      sd2
	  decfsz    dt1
	  goto      sd3
          return



          END            ; directive 'end of program'



